/*
 * Decompiled with CFR 0.152.
 */
package com.github.monun.survival.kommand.argument;

import com.github.monun.survival.kommand.KommandContext;
import com.github.monun.survival.kommand.argument.KommandArgument;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0003J\u001f\u0010\u001a\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0017H\u0016\u00a2\u0006\u0002\u0010\u001eR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR$\u0010\u000e\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u0002@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R$\u0010\u0013\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u0002@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001f"}, d2={"Lcom/github/monun/survival/kommand/argument/DoubleArgument;", "Lcom/github/monun/survival/kommand/argument/KommandArgument;", "", "()V", "allowInfinite", "", "getAllowInfinite", "()Z", "setAllowInfinite", "(Z)V", "allowNaN", "getAllowNaN", "setAllowNaN", "value", "maximum", "getMaximum", "()D", "setMaximum", "(D)V", "minimum", "getMinimum", "setMinimum", "parseFailMessage", "", "getParseFailMessage", "()Ljava/lang/String;", "parse", "context", "Lcom/github/monun/survival/kommand/KommandContext;", "param", "(Lcom/github/monun/kommand/KommandContext;Ljava/lang/String;)Ljava/lang/Double;", "kommand"})
public final class DoubleArgument
implements KommandArgument<Double> {
    private double maximum = Double.MAX_VALUE;
    private double minimum = -4.9E-324;
    private boolean allowInfinite;
    private boolean allowNaN;

    @Override
    @NotNull
    public String getParseFailMessage() {
        return "<argument> <-- " + this.minimum + " ~ " + this.maximum + " \uc0ac\uc774\uc758 \uc2e4\uc218\uac00 \uc544\ub2d9\ub2c8\ub2e4.";
    }

    public final double getMaximum() {
        return this.maximum;
    }

    public final void setMaximum(double value) {
        boolean bl = value >= this.minimum;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "maximum " + value + " was not more than minimum " + this.minimum + '.';
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        this.maximum = value;
    }

    public final double getMinimum() {
        return this.minimum;
    }

    public final void setMinimum(double value) {
        boolean bl = value <= this.maximum;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "minimum " + value + " was not less than maximum " + this.maximum + '.';
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        this.minimum = value;
    }

    public final boolean getAllowInfinite() {
        return this.allowInfinite;
    }

    public final void setAllowInfinite(boolean bl) {
        this.allowInfinite = bl;
    }

    public final boolean getAllowNaN() {
        return this.allowNaN;
    }

    public final void setAllowNaN(boolean bl) {
        this.allowNaN = bl;
    }

    @Override
    @Nullable
    public Double parse(@NotNull KommandContext context, @NotNull String param) {
        Double d;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)param, (String)"param");
        Double d2 = StringsKt.toDoubleOrNull((String)param);
        if (d2 != null) {
            boolean bl;
            Double d3 = RangesKt.coerceIn((double)d2, (double)this.minimum, (double)this.maximum);
            boolean bl2 = false;
            boolean bl3 = false;
            double it = ((Number)d3).doubleValue();
            boolean bl4 = false;
            double d4 = it;
            boolean bl5 = false;
            if (Double.isInfinite(d4)) {
                bl = this.allowInfinite;
            } else {
                d4 = it;
                bl5 = false;
                bl = Double.isNaN(d4) ? this.allowNaN : true;
            }
            d = bl ? d3 : null;
        } else {
            d = null;
        }
        return d;
    }

    @Override
    @NotNull
    public Collection<String> listSuggestion(@NotNull KommandContext context, @NotNull String target) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return KommandArgument.DefaultImpls.listSuggestion(this, context, target);
    }
}

